/**************************************************************************
*           Copyright (c) 2001, Cisco Systems, All Rights Reserved
***************************************************************************
*
*  File:    linuxcniapi.h
*  Date:    4/3/01
*
***************************************************************************
* This module contains the prototypes for the translation layer between the
* CNI API and the Linux Interceptor driver.
***************************************************************************/
#ifndef _LINUXCNIAPI_H_
#define _LINUXCNIAPI_H_

/*************************** internal binding structure ********************/
typedef struct
{
    BOOL called;
    int rc;
} inject_status;
typedef struct {
    /*desription of the device */
    struct device *pDevice;
    struct packet_type *pPT;
    int (*InjectReceive) (struct sk_buff *, struct device *,
                          struct packet_type *);
    int (*InjectSend) (struct sk_buff * skb, struct device * dev);
    int original_mtu;
    struct dst_entry *dst;

    BOOL injectSendCalled;
    BOOL injectRecvCalled;
    inject_status send_stat;
    inject_status recv_stat;
} BINDING, *PBINDING;

/********************************************************************************/

CNISTATUS CNI_LINUXMemAlloc(IN UINT uiSize, OUT PVOID * ppMem);
PVOID CNI_LINUXMemRealloc(IN UINT uiSize, IN PVOID pMem);
CNISTATUS CNI_LINUXMemFree(IN CHAR * pMem);
CNISTATUS CNI_LINUXNewPacket(IN UINT uiSize, IN OUT PCNIPACKET pPacket);
CNISTATUS CNI_LINUXReleasePacket(IN CNIPACKET Packet, IN ULONG ulFlags);
CNISTATUS
CNI_LINUXGetPacketData(IN CNIPACKET Packet,
                       IN ULONG ulOffset,
                       IN ULONG ulSize, OUT PCHAR pBuffer);
CNISTATUS
CNI_LINUXSetPacketData(IN CNIPACKET Packet,
                       IN ULONG ulOffset,
                       IN ULONG ulSize,
                       IN PCHAR pBuffer, IN ULONG ulFlags);
CNISTATUS
CNI_LINUXQueryPacket(IN CNIPACKET Packet,
                     OUT PULONG pulSize OPTIONAL,
                     OUT PULONG pulNumFragments OPTIONAL,
                     OUT PCNIFRAGMENT pFirstFragment OPTIONAL,
                     OUT PCNIFRAGMENT pLastFragment OPTIONAL);
CNISTATUS
CNI_LINUXAddFragToFront(IN CNIPACKET Packet, IN CNIFRAGMENT Fragment);
CNISTATUS
CNI_LINUXCopyFragment(IN CNIFRAGMENT SourceFragment,
                      IN OUT PCNIFRAGMENT pDestFragment, IN ULONG ulFlags);
CNISTATUS
CNI_LINUXNewFragment(IN ULONG ulSize,
                     IN CHAR * pBuffer,
                     OUT CNIFRAGMENT * pFragment, IN ULONG ulFlags);
CNISTATUS
CNI_LINUXReleaseFragment(IN CNIFRAGMENT Fragment, IN ULONG ulFlags);
CNISTATUS
CNI_LINUXSetFragmentLength(IN OUT CNIFRAGMENT Fragment,
                           IN ULONG ulLength, IN OUT CNIPACKET Packet);
CNISTATUS
CNI_LINUXGetFragmentInfo(IN CNIFRAGMENT Fragment,
                         OUT PCHAR * ppData, OUT ULONG * pulLength);
CNISTATUS
CNI_LINUXGetFrameType(IN CNIBINDING Binding, OUT PNICMEDIUM pMedium);
CNISTATUS
CNI_LINUXGetMacAddress(IN CNIBINDING Binding,
                       OUT PCHAR * ppMacAddress,
                       OUT ULONG * pulMacAddressSize);
CNISTATUS
CNI_LINUXGetMacName(IN CNIBINDING Binding, OUT PCHAR * pszMacName);
CNISTATUS
CNI_LINUXGetMTUSize(IN CNIBINDING Binding, OUT PULONG pulMtuSize);
CNISTATUS
CNI_LINUXInjectReceive(IN CNIBINDING Binding,
                       IN PVOID ReceiveContext,
                       IN CNIFRAGMENT MacHeader,
                       IN CNIPACKET Packet, IN ULONG ulSize);
CNISTATUS
CNI_LINUXInjectSend(IN CNIBINDING Binding,
                    IN PVOID SendContext,
                    IN CNIFRAGMENT MacHeader, IN CNIPACKET Packet);


CNIBINDING CNI_LINUXGetTrueBinding(IN CNIBINDING Binding);

CNIBINDING CNI_LINUXGetBindingforIpcUdp(IN CNIBINDING Binding);

#endif                          /* _LINUXCNIAPI_H_ */
